// Philips 591 I2C Demonstration Project 1
// For the Phytec Development Board with 87C591 phyCORE module
// using the Keil 8051 C Compiler
// (C) Embedded Systems Academy 2000
// Version 1.00 Written by AA 3/10/00

// This program stores a byte in the serial EEPROM then reads it back
// complete with error checking and timeout recovery
// The program results are output through the UART. Connect using:
// 9600 baud, 8-N-1, no flow control.

// This program does not demonstrate writing whole pages to the EEPROM.
// The Serial EEPROM is 4kb in size, therefore valid addresses are 000H - FFFH
// eeprom_write_byte and eeprom_read_byte do not return until there is either
// an error or a successful storage. Both functions wait up to 22ms for the
// EEPROM to be ready using a polling method. The status may be read in the
// variable i2c_status and will be I2C_OK or I2C_ERROR

#include "reg591.h"
#include "i2ceeprom.h"
#include <stdio.h>

void init_uart(void);

// function init_uart
// initializes the UART so that the program may display what it is doing
// nothing is passed. nothing is returned
void init_uart(void)
{
  TMOD  = 0x20;                            // timer 1 Mode 2 8 bit, auto-reload
  TH1   = 0xF3;                            // 9600 baud
  PCON  = PCON|0x80;                       // SMOD1 = 1
  S0CON = 0x5A;                            // mode 1, 8-bit, reception enable
  TR1   = 1;                               // timer 1 run
}

// function main
// this function must never return
// nothing is passed. nothing is returned
void main(void)
{
  unsigned char byte = 0x63;               // value to store in EEPROM
  unsigned int location = 0x102;           // location to store value
  init_uart();                             // initialize the UART
  init_i2c();                              // initialize the I2C

  eeprom_write_byte(location, byte);       // store the value at location 102H
  if (i2c_status == I2C_ERROR)             // if there was an error display error msg
    printf("Error writing to EEPROM\n");
  else
    printf("%b2.2XH written to EEPROM at %3.3XH\n", byte, location);

  byte = eeprom_read_byte(location);       // read the value at location 102H
  if (i2c_status == I2C_ERROR)             // if there was an error display error msg otherwise display value read
    printf("Error reading from EEPROM\n");
  else
    printf("%b2.2XH read from EEPROM at %3.3XH\n", byte, location);

  while(1);                                // infinate loop - main function must never return
}

